package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class GreenEnemyScreenObject extends MobileScreenObject implements CloneableScreenObject {

	private IntRect clickRect;
	
	private boolean isSelected;
	
	public static final int ENEMY_WIDTH = 64;
	public static final int ENEMY_HEIGHT = 64;
	
	
	private static CustomImageDataII greenEnemyImage;
	
	
	private static synchronized void loadRedEnemyImage(ImageObserver io) {
		
		greenEnemyImage = new CustomImageDataII("/images/enemy/green/elemental L green 1.GIF", Color.white, io);
		
	}
	
	
	public GreenEnemyScreenObject(int x, int y, ImageObserver io) {
		
		if(greenEnemyImage == null) {
			loadRedEnemyImage(io);
		}
		
		clickRect = new IntRect(x - ENEMY_WIDTH/2, y - ENEMY_HEIGHT/2, ENEMY_WIDTH, ENEMY_HEIGHT);
		isSelected = false;
		
		this.setVertical(true);
		
		this.setMin(y);
		this.setMax(y);
		
	}
	
	public GreenEnemyScreenObject(int x, int y, ImageObserver io, int min, int max) {
		
		if(greenEnemyImage == null) {
			loadRedEnemyImage(io);
		}
		
		clickRect = new IntRect(x - ENEMY_WIDTH/2, y - ENEMY_HEIGHT/2, ENEMY_WIDTH, ENEMY_HEIGHT);
		isSelected = false;
		
		this.setVertical(true);
		
		this.setMin(min);
		this.setMax(max);
		
	}
	
	
	
	@Override
	public void draw(Graphics g) {
		if(greenEnemyImage != null) {
			
			Point center = clickRect.getCenter();
			
			Color origColor = g.getColor();
			
			g.setColor(new Color(0, 0, 255));
			g.drawLine(center.x - 5, center.y, center.x - 5, this.getMin());
			g.drawLine(center.x + 5, center.y, center.x + 5, this.getMin());
			
			g.setColor(new Color(0, 51, 255));
			g.drawLine(center.x - 4, center.y, center.x - 4, this.getMin());
			g.drawLine(center.x + 4, center.y, center.x + 4, this.getMin());
			
			g.setColor(new Color(0, 102, 255));
			g.drawLine(center.x - 3, center.y, center.x - 3, this.getMin());
			g.drawLine(center.x + 3, center.y, center.x + 3, this.getMin());
			
			g.setColor(new Color(0, 153, 255));
			g.drawLine(center.x - 2, center.y, center.x - 2, this.getMin());
			g.drawLine(center.x + 2, center.y, center.x + 2, this.getMin());
			
			g.setColor(new Color(0, 204, 255));
			g.drawLine(center.x - 1, center.y, center.x - 1, this.getMin());
			g.drawLine(center.x + 1, center.y, center.x + 1, this.getMin());
			
			g.setColor(new Color(0, 255, 255));
			g.drawLine(center.x, center.y, center.x, this.getMin());
			g.drawLine(center.x + 10, this.getMin(), center.x - 10, this.getMin());
			
			
			
			
			g.setColor(new Color(255, 0, 0));
			g.drawLine(center.x - 5, center.y, center.x - 5, this.getMax());
			g.drawLine(center.x + 5, center.y, center.x + 5, this.getMax());
			
			g.setColor(new Color(255, 51, 0));
			g.drawLine(center.x - 4, center.y, center.x - 4, this.getMax());
			g.drawLine(center.x + 4, center.y, center.x + 4, this.getMax());
			
			g.setColor(new Color(255, 102, 0));
			g.drawLine(center.x - 3, center.y, center.x - 3, this.getMax());
			g.drawLine(center.x + 3, center.y, center.x + 3, this.getMax());
			
			g.setColor(new Color(255, 153, 0));
			g.drawLine(center.x - 2, center.y, center.x - 2, this.getMax());
			g.drawLine(center.x + 2, center.y, center.x + 2, this.getMax());
			
			g.setColor(new Color(255, 204, 0));
			g.drawLine(center.x - 1, center.y, center.x - 1, this.getMax());
			g.drawLine(center.x + 1, center.y, center.x + 1, this.getMax());
			
			g.setColor(new Color(255, 255, 0));
			g.drawLine(center.x, center.y, center.x, this.getMax());
			g.drawLine(center.x + 10, this.getMax(), center.x - 10, this.getMax());
			
			
			
			g.setColor(origColor);
			
			greenEnemyImage.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		}
		
		drawInitialDirIndicator(g);
		
		if(isSelected)
			drawSelectionOverObject(g);
		
		
		
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}


	@Override
	public void setClickRect(IntRect newRect) {
		// TODO Auto-generated method stub
		
	}
	
	
	public void writeOutToFile(BufferedWriter out) throws Exception{
		
		out.write("enemy:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("green");
		out.newLine();
		
		out.write("minY:");
		out.write(Integer.toString(this.getMin()));
		out.newLine();
		
		out.write("maxY:");
		out.write(Integer.toString(this.getMax()));
		out.newLine();
		
		
		out.write("dir:");
		if(this.isGoingMinDirection()) {
			out.write("u");
		} else {
			out.write("d");
		}
		out.newLine();
		
		out.write("/enemy");
		out.newLine();
		
		out.newLine();
	}
	
	
	
	
	public GreenEnemyScreenObject clone(ImageObserver io) {
		
		Point centerPoint = clickRect.getCenter();
		
		GreenEnemyScreenObject returnValue = new GreenEnemyScreenObject(centerPoint.x, centerPoint.y, io);
		returnValue.setMax(this.getMax());
		returnValue.setMin(this.getMin());
		returnValue.setGoingMinDirection(this.isGoingMinDirection());
		returnValue.setPaletteObject(this.getPaletteObject());

		return returnValue;
		
		
	}
	
	

	
	@Override
	public int getLayer() {
		
		return 14;
	}
}
